$(function()
  {
    
    // Add the numbers to the items in the HIW menu...
    $('#hiw ol li h2, #license-api  ol li h2').each(
        function(i)
        {
            $(this).append(
                $('<span class="num" />').
                    css(
                        {
                            'background-position':'0 ' + ((i+1) * -22) + 'px'
                        }
                    )
            )
        }
    )
    
    // zebra the admin table
    $('#admin tr:even').addClass('odd');
    
    // and add the hover style
    /*
    $('#admin tr:not(.page-list)').hover(
        function()
        {
            $(this).addClass('hover');
        },
        function()
        {
            $(this).removeClass('hover');
        }
    )
    */
    
    // highlight the active admin sidelink
    var h = document.location.href;
    var u = h.substring(h.indexOf('/', 8));
    // messy way of getting rid of the page number or id at the end of the URL...
    var s = u.split('/');
    while (s.length > 4) {
        s.pop();
    }
    $('#admin-left-nav a[href=' + s.join('/') + ']').parent().addClass('active');
    
    // swap real submit buttons for pretty styled links... We know the user has JS enabled if this runs so they will be
    // able to submit the form by the JS of clicking on the link...
    $(':submit').each(
        function()
        {
            var $this = $(this);
            var f = this.form;
            var link = $('<a href="#">' + $this.val() + '</a>')
                .bind(
                    'click',
                    function()
                    {
                        $(f).trigger('submit');
                        return false;
                    }
                )
            $this.after(link).css({position:'absolute', top:'-2000px'});
        }
    )
    
    // FAQs
    var $h2;
    var $answer;
    $('.answer').hide();
    $('#faq h2').bind(
        'click',
        function()
        {
            if ($h2 && $h2[0] != this) {
                $answer.slideUp();
                $h2.removeClass('open');
            }
            $h2 = $(this);
            $answer = $h2.next();
            $answer.slideDown();
            $h2.addClass('open');
        }
    )
    
    // Tooltips
    $('.tt').each(
        function()
        {
            var $tt = $(this);
            $tt.simpletip(
                $tt.attr('title'),
                {
                    hook: {
                        tooltip: 'topLeft',
                        target: 'bottomLeft'
                    },
                    offset: [20, -5],
                    stem: {
                        corner: 'topLeft',
                        color: '#000',
                        size: 15
                    }
                }
            ).attr('title', '');
        }
    );
    
    // Form validation
    $forms = $('.validated-form');
    if ($forms.length) {
     
        $forms.validate(
        {
            errorPlacement: function(error, element)
                {
                    element.after(error);
                    error.hide().slideDown();
                }
        }
    );   
    }
    
    // add copy option for license key
    $('.copy-to-clipboard-content').each(
        function(i)
        {
            var $this = $(this);
            $copyLink = $('<a href="#" class="copy-to-clipboard">Copy to clipboard</a>');
            $this.after($copyLink);
            
            ZeroClipboard.setMoviePath('/swf/ZeroClipboard.swf');
            var clip = new ZeroClipboard.Client();
            clip.setText($this.text());
            clip.glue($copyLink[0]);
            
            $('#ZeroClipboardMovie_' + (i+1)).parent().simpletip(
                'Copy to clipboard',
                {
                    hook: {
                        tooltip: 'topLeft',
                        target: 'bottomLeft'
                    },
                    offset: [10, 10],
                    stem: {
                        corner: 'topLeft',
                        color: '#000',
                        size: 15
                    }
                }
            ).attr('title', '');
        }
    );
    
    // IE6
    if ($.browser.msie && $.fn.supersleight) {
        $('#ie6-header').html('<p>You appear to be using Internet Explorer 6 to view this site. We warn you that this will provide you with a degraded experience and recommend you update to a <a href="http://www.mozilla.com/">better</a> or at least a <a href="http://www.microsoft.com/windows/products/winfamily/ie/default.mspx">newer</a> browser.</p>');
        
        $('body').supersleight(
          {
            shim: '/images/shim.gif',
            backgrounds: false
          }
        );
    }
    
    // Reset password
    $('#reset-password-form').bind(
        'submit',
        function()
        {
            var p1 = $('#password').val();
            if (p1 == '') {
                alert('You must enter a password.');
                return false;
            }
            if (p1 != $('#password2').val()) {
                alert('The passwords must match.');
                return false;
            }
            return true;
        }
    );
    
  });